@spritesheet theme
{
	src: hud_global.png;

	checkbox: 0px 100px 32px 32px;
	checkbox-hover: 0px 100px 32px 32px;
	checkbox-active: 0px 100px 32px 32px;
	
	checkbox-checked: 64px 100px 32px 32px;
	checkbox-checked-hover: 64px 100px 32px 32px;
	checkbox-checked-active: 64px 100px 32px 32px;
	
	
	
	checkbox-checked1: 32px 100px 32px 32px;
	checkbox-checked-hover1: 32px 100px 32px 32px;
	checkbox-checked-active1: 32px 100px 32px 32px;

	radio: 0px 132px 32px 32px;
	radio-hover: 0px 132px 32px 32px;
	radio-active: 0px 132px 32px 32px;
	radio-checked: 32px 132px 32px 32px;
	radio-checked-hover: 32px 132px 32px 32px;
	radio-checked-active: 32px 132px 32px 32px;

	selectbox-tl: 4px 0px 11px 10px;
	selectbox-t:  13px 0px 1px 10px;
	selectbox-tr: 122px 0px 11px 10px;

	selectbox-l:  4px 19px 11px 4px;
	selectbox-c:  13px 19px 4px 4px;
	selectbox-r:  128px 19px 11px 4px;

	selectbox-bl: 4px 22px 11px 10px;
	selectbox-b:  13px 22px 1px 10px;
	selectbox-br: 122px 22px 11px 10px;
	
	dropdown-arrow: 0px 179px 24px 24px;
	dropdown-arrow-hover: 0px 192px 24px 24px;
}

body {
    font-family: Noto Sans SC;
    font-weight: normal;
    font-style: normal;
    font-size: 15dp;
    color: white;
    margin: 0px;
    padding: 0px;
    width: 100%;
    height: 100%;
}

.input-dropdown .dropdown-icon {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    width: 24px;
    height: 24px;
    cursor: pointer;
    decorator: image(dropdown-arrow); /* icon mặc định trắng */
}

.input-dropdown .dropdown-icon:hover {
    decorator: image(dropdown-arrow-hover); /* icon cam */
}

input.checkbox
{
	decorator: image(checkbox);
}

input.checkbox:hover, input.checkbox:focus-visible
{
	decorator: image(checkbox-hover);
}

input.checkbox:active
{
	decorator: image(checkbox-active);
}

input.checkbox:checked
{
	decorator: image(checkbox-checked);
}

input.checkbox:checked:hover, input.checkbox:checked:focus-visible
{
	decorator: image(checkbox-checked-hover);
}

input.checkbox:checked:active
{
	decorator: image(checkbox-checked-active);
}

input.radio
{
	decorator: image(radio);
}

input.radio:hover, input.radio:focus-visible
{
	decorator: image(radio-hover);
}

input.radio:active
{
	decorator: image(radio-active);
}

input.radio:checked
{
	decorator: image(radio-checked);
}

input.radio:checked:hover, input.radio:checked:focus-visible
{
	decorator: image(radio-checked-hover);
}

input.radio:checked:active
{
	decorator: image(radio-checked-active);
}

select selectbox
{
	margin-left: 10px;
	margin-top: 10px;
	margin-bottom: 10px;
	width: 162px;
	padding: 4px 4px 4px 4px;
}

select selectbox,
tbody
{
	decorator: tiled-box(
		selectbox-tl, selectbox-t, selectbox-tr,
		selectbox-l, selectbox-c, selectbox-r,  /* auto mirrors left */
		selectbox-bl, selectbox-b, selectbox-br
	);
}

.background {
    position: absolute;
    width: 100%;
    height: 100%;
    decorator: image(bg.jpg);
    background-size: cover;
    background-repeat: no-repeat;
    background-position: center;
}

.login-container {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    border-radius: 10px;
    width: 280px;
    padding: 5px;
    background-color: rgba(10, 10, 10, 178);
    border-radius: 12px;
    text-align: left;
	font-size: 13px; 
}

.header-img {

    display: block;
    margin: 0px;
    padding: 0px;
    width: 100px;
    height: 118px;
    decorator: image(logo.png);
	margin: 0 auto 10px auto;
	background-position: center;
}

.login-container h2 {
    margin-top: 10;
    font-size: 20px;
    font-weight: normal;
    text-align: center;
}

#server_name {
    font-size: 16px;
    display: block;
}

.login-container input {
      width: 94%;
      padding: 8px ;
      margin: 8px  0;
      border: 1px solid #444;
      border-radius: 5px;
      background-color: #1e1e1e;
      color: #fff;
    }

input::placeholder {
    color: #ccc;
    font-style: italic;
}

.login-container button {
    display: block;
    width: 94%;
    padding: 10px;
    margin-top: 10px;
    border: none;
    border-radius: 5px;
	background-color: rgba(10, 200, 255, 178);
    color: #fff;
    font-weight: bold;
    text-align: center;
    line-height: normal;
    transition: background 0.2s ease-in-out;
}

/*Hover: đổi sang màu xanh lá cây */
.login-container button:hover {
    background: #FF8800; /* Màu xanh lá cây tươi */
}
.button-row {
    display: flex;
    justify-content: center;
    gap: 8px;
    margin-top: 8px;
}

.button-row button {
    display: inline-block;
    width: 45%; /* o el tamaño que prefieras */
}

#btn_register {
    margin-top: 10px;
    margin-right: 10px;
}

.login-container input[type="checkbox"]
{
    width: 8px;
    height: 8px;
    margin-right: 8px;
    vertical-align: middle;
}

.login-container select {

    display: block;
    width: 200px;
    height: 30px;
    font-size: 20px;
    margin: 10px;
}

#quenmatkhau {
    color: #ffffff;        /* màu chữ mặc định (trắng) */
    text-decoration: none; /* bỏ gạch chân mặc định */
    cursor: pointer;       /* hiện dấu tay khi hover */
    transition: color 0.2s ease-in-out;
}

#quenmatkhau:hover {
    color: #00cc66; /* xanh lá cây khi hover */
    text-decoration: underline; /* có thể thêm gạch chân nếu muốn */
}